#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Tri Voronoi another coloringMod01.fsh   by   AieKick
//https://www.shadertoy.com/view/3sGSzc
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.177  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Created by Stephane Cuillerdier - Aiekick/2019 (twitter:@aiekick)
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.
// Tuned via NoodlesPlate (https://github.com/aiekick/NoodlesPlate/releases)

const vec3 color0 = vec3(0.2,0.1,0.3);
const vec3 color1 = vec3(0.6,0.1,1.9);
const vec3 lightColor = vec3(0.7,1.6,0.6);

vec3 shape(vec2 g)
{
	float c = 9.0;
    	
    float t = iTime;
	float t1 = t * 0.1;
	
	vec2 p = vec2(0), sp = p;
	
    g *= 2.0;
    
    for(int x=-2;x<=2;x++)
    for(int y=-2;y<=2;y++)
    {	
        p = vec2(x,y);
        p += .5 + .5*sin( t1 * 10. + 9. * fract(sin((floor(g)+p)*mat2(2,5,5,2)))) - fract(g);
        p *= mat2(cos(t1), -sin(t1), sin(t1), cos(t1));
        float d = max(abs(p.x)*.866 - p.y*.5, p.y);
        if (d < c)
        {
            c = d;
            sp = p;
        }
    }

    return vec3(c,sp);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = (fragCoord * 2.0 - iResolution.xy)/iResolution.y;
	
	float t = iTime * 0.5;
	
    float k = 0.01;
	vec3 f = shape(uv);
	float fx = shape(uv + vec2(k,0.0)).x-f.x;
	float fy = shape(uv + vec2(0.0, k)).x-f.x;
	
    vec3 n = normalize(vec3(fx, 0.1, fy) );
	
	vec3 col = mix( color0, color1, f.x );

    float r = sin(t + f.y)*cos(t + f.z) * .5 + .5;
	col = mix(col.xyz, mix(col.zxy, col.yzx, r), 1.-r);
    
	col += .4 * pow(max(dot( n, vec3(0,1,0)), 0.), 100.) * lightColor;
	
	fragColor = vec4( col, 1.0 );
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

